% SMAS estimation of price indexation in Smets and Wouters(2007) model

clear all;
load('sampledata_sub_236');
sampledata = sampledata_sub_236(:, :, :);
[d, T, s] = size(sampledata);

rng('default');
rng('shuffle');
valid = 1;

global p h posR;
p = 4;
h = 80;
hs = 21;
n_obs = 4;
n_irfs = (h - hs + 1)*n_obs;
posC = 4;
posR = 7;
% pos_var = [1 2 3 4 5 6 7];
pos_var = [4 5 6 7];
true_param_p1 = 0.469;
true_param_p2 = 0.908;

v_est_p1 = zeros(s, 1);
v_est_p2 = zeros(s, 1);
v_est_p1_reg = zeros(s, 1);
v_est_p2_reg = zeros(s, 1);
v_est_p1_nonreg = zeros(s, 1);
v_est_p2_nonreg = zeros(s, 1);
v_est_p1_opt_reg = zeros(s, 1);
v_est_p2_opt_reg = zeros(s, 1);
v_est_p1_opt_nonreg = zeros(s, 1);
v_est_p2_opt_nonreg = zeros(s, 1);
v_pick_c_1 = zeros(s, 1);
v_pick_c_2 = zeros(s, 1);

% set the range of grid search
p1_range = 0.05:0.05:0.95;

% vector of candidate alpha values
c_a = [0.1 0.05 0.01 0.005 0.001 0.0001 10^(-5) 10^(-6) 0];

N = 100;
trainingT = round(2/3*T);
training = sampledata(:, 1:trainingT, :);
testing = sampledata(:, trainingT+1:T, :);
ST = ceil(0.75*(T^(1/3)));
ST_training = ceil(0.75*(trainingT^(1/3)));

% estimate with training sample
for i = 1:s
    aaa = i
    valid
    try % if irf can't be calculated from the synthetic data, directly show 'sample failed'

    v_sampledata_full = sampledata(:, :, i); 
    [Af,SIGMAf,Uf,Vf] = olsvarc(v_sampledata_full', p);
    sampleirf_full = irfvar_single(Af,SIGMAf,p); % irfs generated for this simulated path with true alpha, not vectorized
    sampleirf_full = sampleirf_full(pos_var, :); % select responses to match
    sampleirf_full = vec(sampleirf_full);
    
    % training irf
    v_sampledata = training(:, :, i);
    [A,SIGMA,U,V] = olsvarc(v_sampledata', p);
    sampleirf = irfvar_single(A,SIGMA,p);
    sampleirf = sampleirf(pos_var, :);
    sampleirf = vec(sampleirf);
    
    %testing irf
    v_sampletest = testing(:, :, i); 
    [At,SIGMAt,Ut,Vt] = olsvarc(v_sampletest', p);
    testirf = irfvar_single(At,SIGMAt,p);
    testirf = testirf(pos_var, :);
    testirf = vec(testirf);
    
    irf_star = zeros(n_obs, (h+1), N);
    v_irf_star = zeros(n_obs*(h+1), N);
    
    irf_star_1a = zeros(n_obs, (h+1), N);
    irf_star_1b = zeros(n_obs, (h+1), N);
    irf_star_2a = zeros(n_obs, (h+1), N);
    irf_star_2b = zeros(n_obs, (h+1), N);
    irf_star_3a = zeros(n_obs, (h+1), N);
    irf_star_3b = zeros(n_obs, (h+1), N);
    irf_star_4a = zeros(n_obs, (h+1), N);
    irf_star_4b = zeros(n_obs, (h+1), N);
    irf_star_5a = zeros(n_obs, (h+1), N);
    irf_star_5b = zeros(n_obs, (h+1), N);
    
    for n = 1:N
        [IRFii IRFii_ST]=bootirf_single_opt(A,U,v_sampledata',V, ST_training);
        irf_star(:, :, n) = IRFii(pos_var, :);
        v_irf_star(:, n) = vec(IRFii(pos_var, :));
        irf_star_1a(:,:,n) = IRFii_ST(pos_var,:,1);
        irf_star_1b(:,:,n) = IRFii_ST(pos_var,:,2);
        irf_star_2a(:,:,n) = IRFii_ST(pos_var,:,3);
        irf_star_2b(:,:,n) = IRFii_ST(pos_var,:,4);
        irf_star_3a(:,:,n) = IRFii_ST(pos_var,:,5);
        irf_star_3b(:,:,n) = IRFii_ST(pos_var,:,6);
        irf_star_4a(:,:,n) = IRFii_ST(pos_var,:,7);
        irf_star_4b(:,:,n) = IRFii_ST(pos_var,:,8);
        irf_star_5a(:,:,n) = IRFii_ST(pos_var,:,9);
        irf_star_5b(:,:,n) = IRFii_ST(pos_var,:,10);
    end
    
    mean_irf_star = mean(v_irf_star, 2); % calculate the mean of irf from N paths
    demean_irf_star = irf_star-mean(irf_star,3);
    demean_irf_star_1a = irf_star_1a-mean(irf_star_1a,3);
    demean_irf_star_1b = irf_star_1b-mean(irf_star_1b,3);
    demean_irf_star_2a = irf_star_2a-mean(irf_star_2a,3);
    demean_irf_star_2b = irf_star_2b-mean(irf_star_2b,3);
    demean_irf_star_3a = irf_star_3a-mean(irf_star_3a,3);
    demean_irf_star_3b = irf_star_3b-mean(irf_star_3b,3);
    demean_irf_star_4a = irf_star_4a-mean(irf_star_4a,3);
    demean_irf_star_4b = irf_star_4b-mean(irf_star_4b,3);
    demean_irf_star_5a = irf_star_5a-mean(irf_star_5a,3);
    demean_irf_star_5b = irf_star_5b-mean(irf_star_5b,3);
    Cm = zeros(N, N);
    Cm_opt = zeros(N, N);    
    for b = 1:N
        for bprime = 1:N
            Cbb = 0;
            Cbb_opt = 0;
            for ss = hs: h
                Cbb = Cbb + irf_star(:, ss+1, b)'* irf_star(:, ss+1, bprime)/N;
                Cbb_opt = Cbb_opt...
                    + (demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)...
                    + 2*((1-1/ST_training)*demean_irf_star_1a(:,ss+1,b)'*demean_irf_star_1b(:,ss+1,bprime)...
                        +(1-2/ST_training)*demean_irf_star_2a(:,ss+1,b)'*demean_irf_star_2b(:,ss+1,bprime)...
                        +(1-3/ST_training)*demean_irf_star_3a(:,ss+1,b)'*demean_irf_star_3b(:,ss+1,bprime)...
                        +(1-4/ST_training)*demean_irf_star_4a(:,ss+1,b)'*demean_irf_star_4b(:,ss+1,bprime)...
                        +(1-5/ST_training)*demean_irf_star_5a(:,ss+1,b)'*demean_irf_star_5b(:,ss+1,bprime)))/N;
            end
            Cm(b, bprime) = Cbb;
            Cm_opt(b, bprime) = Cbb_opt;
        end
    end
    
    [Beta lambda] = eig(Cm); 
    [Beta_opt lambda_opt] = eig(Cm_opt); 
    % columns of Beta are the corresponding right eigenvectors
    % lambda is a diagonal matrix, elements on diagonal being the
    % eigenvalues
    
    % construct the eigenfunctions using Beta
    
    psi = v_irf_star((n_obs*hs + 1):n_obs*(h+1), :) - mean_irf_star((n_obs*hs+1):n_obs*(h+1));
    phi = psi * Beta/N;
    % normalize phi
    phi = (phi'./sqrt(diag(phi' * phi)))';
    
    psi_opt = demean_irf_star+2*((1-1/ST_training)*demean_irf_star_1a...
                            +(1-2/ST_training)*demean_irf_star_2a...
                            +(1-3/ST_training)*demean_irf_star_3a...
                            +(1-4/ST_training)*demean_irf_star_4a...
                            +(1-5/ST_training)*demean_irf_star_5a);
    psi_opt = reshape(psi_opt, n_obs*(h+1), N);
    psi_opt = psi_opt((n_obs*hs + 1):n_obs*(h+1), :);
    phi_opt = psi_opt * Beta_opt/N;
    % normalize phi
    phi_opt = (phi_opt'./sqrt(diag(phi_opt' * phi_opt)))';
    
    % do grid search among candidate alphas, find the 'first step estimate'
    irfs = zeros(n_obs*(h+1), length(p1_range)); % h+1 because contemporary response will be computed
%     first_time = 1;
    dynare sw_select noclearall;
    % for each of the alphas, calculate irfs and increase the number of
    % simulations to reduce impact from randomness

    for n_p1=1:length(p1_range)

        set_param_value('gamma_p',p1_range(n_p1)); % update param values, get the simulation
        %set_param_value('xi_p',p2_range(n_p2));
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

%         end
        
        simdata = sim_array(1:7,1001:(1000 + trainingT), :);% extract simdata in dataset generated, take first 2/3   
        
        m_irf_path = zeros(n_obs*(h+1), 10);
        count = 1;
        j = 1;
            
            while count < 11
                try
                simdata_path = simdata(:, :, j);
                [Apath,SIGMApath,Upath,Vpath] = olsvarc(simdata_path', p);
                [IRFr]=bootirf_single(Apath,U,v_sampledata',Vpath);
                irf_path = vec(IRFr(pos_var,:));
                m_irf_path(:, count) = irf_path;
                count = count + 1;
                catch
                    count = count;
                end
                j = j+1;
            end
        mean_irf = sum(m_irf_path, 2)/10; 
        irfs(:, n_p1) = mean_irf;
    end

    dis = sampleirf((n_obs*hs+1):n_obs*(h+1)) - irfs((n_obs*hs+1):n_obs*(h+1), :); 
    dis_sqr = sum(dis.^2, 1); 
    dis_sqr = squeeze(dis_sqr);
    
    reg_a = c_a./(trainingT^(1/3));
    v_obj = zeros(length(p1_range),1);
    v_d_sqr_1 = zeros(length(reg_a), 1);   
    v_obj_opt = zeros(length(p1_range),1);
    v_d_sqr_2 = zeros(length(reg_a), 1);

%     rec_p1 = [];
    for aa = 1:length(reg_a)
        for n_p1 = 1:length(p1_range)
            reg_dis = dis(:, n_p1);
            reg_sqr = (phi' * reg_dis).^2; % T by 1 vector
            obj = (diag(lambda)./(diag(lambda).^2 + reg_a(aa)))' * reg_sqr;
            v_obj(n_p1) = obj;
            reg_sqr_opt = (phi_opt' * reg_dis).^2; % T by 1 vector
            obj_opt = (diag(lambda_opt)./(diag(lambda_opt).^2 + reg_a(aa)))' * reg_sqr_opt;
            v_obj_opt(n_p1) = obj_opt;
        end
 %diagonal SMAS       
        p1_temp_loc = find(v_obj == min(v_obj));
        est_p1_temp = p1_range(p1_temp_loc);

        set_param_value('gamma_p',est_p1_temp); 
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            if info
                disp(['Computation fails for alpha = ' num2str(alpha)]);
            end

        simtesting = sim_array(1:7,(1001+trainingT):(1000+T), randi([1 20],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);
        m_irf_testing_1 = zeros(n_obs*(h+1), 10);
            
        for tt = 1:10
            [IRFt1]=bootirf_single(Atest,Ut,v_sampletest',Vtest);
            m_irf_testing_1(:, tt) = vec(IRFt1(pos_var,:));
        end

        mean_irf_testing_1 = mean(m_irf_testing_1,2);
        d_sqr_1 = (testirf((n_obs*hs+1):n_obs*(h+1)) - mean_irf_testing_1((n_obs*hs+1):n_obs*(h+1)))'*(testirf((n_obs*hs+1):n_obs*(h+1)) - mean_irf_testing_1((n_obs*hs+1):n_obs*(h+1)));
        v_d_sqr_1(aa) = d_sqr_1;
% optimal SMAS
        p1_temp_loc = find(v_obj_opt == min(v_obj_opt));
        est_p1_temp = p1_range(p1_temp_loc);
%         est_p2_temp = p2_range(p2_temp_loc);
%         est_alpha_reg_opt = alphas*(v_obj_opt == min(v_obj_opt));

        set_param_value('gamma_p',est_p1_temp);
%         set_param_value('xi_p',est_p2_temp);
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            if info
                disp(['Computation fails for alpha = ' num2str(alpha)]);
            end

        simtesting = sim_array(1:7,(1001+trainingT):(1000+T), randi([1 20],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);            
        m_irf_testing_2 = zeros(n_obs*(h+1), 10);

            for tt = 1:10
                [IRFt2]=bootirf_single(Atest,Ut,v_sampletest',Vtest);
                m_irf_testing_2(:, tt) = vec(IRFt2(pos_var,:));% store the values
            end

        mean_irf_testing_2 = mean(m_irf_testing_2,2);
        d_sqr_2 = (testirf((n_obs*hs+1):n_obs*(h+1)) - mean_irf_testing_2((n_obs*hs+1):n_obs*(h+1)))'...
            *(testirf((n_obs*hs+1):n_obs*(h+1)) - mean_irf_testing_2((n_obs*hs+1):n_obs*(h+1)));
        v_d_sqr_2(aa) = d_sqr_2;        
        
    end
    
    pick_c_1 = c_a(find(v_d_sqr_1 == min(v_d_sqr_1)));
    v_pick_c_1(i) = pick_c_1;
    pick_c_2 = c_a*(v_d_sqr_2 == min(v_d_sqr_2));
    v_pick_c_2(i) = pick_c_2;
    
    irf_star_full = zeros(n_obs, (h+1), N);
    v_irf_star_full = zeros(n_obs*(h+1), N);
    irf_star_full_1a = zeros(n_obs, (h+1), N);
    irf_star_full_1b = zeros(n_obs, (h+1), N);
    irf_star_full_2a = zeros(n_obs, (h+1), N);
    irf_star_full_2b = zeros(n_obs, (h+1), N);
    irf_star_full_3a = zeros(n_obs, (h+1), N);
    irf_star_full_3b = zeros(n_obs, (h+1), N);
    irf_star_full_4a = zeros(n_obs, (h+1), N);
    irf_star_full_4b = zeros(n_obs, (h+1), N);
    irf_star_full_5a = zeros(n_obs, (h+1), N);
    irf_star_full_5b = zeros(n_obs, (h+1), N);
    for n = 1:N
        [IRFfull IRFfull_ST]=bootirf_single_opt(Af,Uf,v_sampledata_full',Vf,ST);
        irf_star_full(:, :, n) = IRFfull(pos_var, :);
        v_irf_star_full(:, n) = vec(IRFfull(pos_var, :));
        irf_star_full_1a(:,:,n) = IRFfull_ST(pos_var,:,1);
        irf_star_full_1b(:,:,n) = IRFfull_ST(pos_var,:,2);
        irf_star_full_2a(:,:,n) = IRFfull_ST(pos_var,:,3);
        irf_star_full_2b(:,:,n) = IRFfull_ST(pos_var,:,4);
        irf_star_full_3a(:,:,n) = IRFfull_ST(pos_var,:,5);
        irf_star_full_3b(:,:,n) = IRFfull_ST(pos_var,:,6);
        irf_star_full_4a(:,:,n) = IRFfull_ST(pos_var,:,7);
        irf_star_full_4b(:,:,n) = IRFfull_ST(pos_var,:,8);
        irf_star_full_5a(:,:,n) = IRFfull_ST(pos_var,:,9);
        irf_star_full_5b(:,:,n) = IRFfull_ST(pos_var,:,10);
    end
    
    mean_irf_star_full = mean(v_irf_star_full, 2); 
    demean_irf_star_full = irf_star_full-mean(irf_star_full,3);  
    demean_irf_star_full_1a = irf_star_full_1a-mean(irf_star_full_1a,3);
    demean_irf_star_full_1b = irf_star_full_1b-mean(irf_star_full_1b,3);
    demean_irf_star_full_2a = irf_star_full_2a-mean(irf_star_full_2a,3);
    demean_irf_star_full_2b = irf_star_full_2b-mean(irf_star_full_2b,3);
    demean_irf_star_full_3a = irf_star_full_3a-mean(irf_star_full_3a,3);
    demean_irf_star_full_3b = irf_star_full_3b-mean(irf_star_full_3b,3);
    demean_irf_star_full_4a = irf_star_full_4a-mean(irf_star_full_4a,3);
    demean_irf_star_full_4b = irf_star_full_4b-mean(irf_star_full_4b,3);
    demean_irf_star_full_5a = irf_star_full_5a-mean(irf_star_full_5a,3);
    demean_irf_star_full_5b = irf_star_full_5b-mean(irf_star_full_5b,3);
    Cf = zeros(N, N);
    Cf_opt = zeros(N, N);    
    for b = 1:N
        for bprime = 1:N
            Cbb_f = 0;
            Cbb_f_opt = 0;
            for ss = hs: h
                Cbb_f = Cbb_f + irf_star_full(:, ss+1, b)'* irf_star_full(:, ss+1, bprime)/N;
                Cbb_f_opt = Cbb_f_opt...
                    + (demean_irf_star_full(:, ss+1, b)'* demean_irf_star_full(:, ss+1, bprime)...
                    + 2*((1-1/ST)*demean_irf_star_full_1a(:,ss+1,b)'*demean_irf_star_full_1b(:,ss+1,bprime)...
                        +(1-2/ST)*demean_irf_star_full_2a(:,ss+1,b)'*demean_irf_star_full_2b(:,ss+1,bprime)...
                        +(1-3/ST)*demean_irf_star_full_3a(:,ss+1,b)'*demean_irf_star_full_3b(:,ss+1,bprime)...
                        +(1-4/ST)*demean_irf_star_full_4a(:,ss+1,b)'*demean_irf_star_full_4b(:,ss+1,bprime)...
                        +(1-5/ST)*demean_irf_star_full_5a(:,ss+1,b)'*demean_irf_star_full_5b(:,ss+1,bprime)))/N;
            end
            Cf(b, bprime) = Cbb_f;
            Cf_opt(b, bprime) = Cbb_f_opt;
        end
    end
    
    [Beta_f lambda_f] = eig(Cf); 
    [Beta_f_opt lambda_f_opt] = eig(Cf_opt);
    psi_f = v_irf_star_full((n_obs*hs + 1):n_obs*(h+1), :) - mean_irf_star_full((n_obs*hs+1):n_obs*(h+1));
    phi_f = psi_f * Beta_f/N;
    % normalize phi
    phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
    
    psi_f_opt = demean_irf_star_full+2*((1-1/ST)*demean_irf_star_full_1a...
                            +(1-2/ST)*demean_irf_star_full_2a...
                            +(1-3/ST)*demean_irf_star_full_3a...
                            +(1-4/ST)*demean_irf_star_full_4a...
                            +(1-5/ST)*demean_irf_star_full_5a);
    psi_f_opt = reshape(psi_f_opt, n_obs*(h+1), N);
    psi_f_opt = psi_f_opt((n_obs*hs + 1):n_obs*(h+1), :);
    phi_f_opt = psi_f_opt * Beta_f_opt/N;
    % normalize phi
    phi_f_opt = (phi_f_opt'./sqrt(diag(phi_f_opt' * phi_f_opt)))';

    irfs_full = zeros(n_obs*(h+1), length(p1_range)); % h+1 because current response will be computed
%     first_time = 1;
    dynare sw_select noclearall;
    for n_p1=1:length(p1_range)
%         if first_time
%         
%         dynare sw_select noclearall;
%         [sim_array]=get_simul_replications(M_,options_); 
%         y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
%         first_time = 0;
%         else
        set_param_value('gamma_p',p1_range(n_p1)); 
        
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

%         end
        
        simdata_alpha = sim_array(1:7,1001:(1000+T), :);
        
        m_irf_path_f = zeros(n_obs*(h+1), 10);
        count = 1;
        j = 1;
            while count < 11
                try
                simdata_path_full = simdata_alpha(:, :, j);
                [Apathf,SIGMApathf,Upathf,Vpathf] = olsvarc(simdata_path_full', p);
                [IRFr_full]=bootirf_single(Apathf,Uf,v_sampledata_full',Vpathf);
                IRFr_full = IRFr_full(pos_var, :);
                irf_path_f = vec(IRFr_full); 
                m_irf_path_f(:, count) = irf_path_f;
                count = count + 1;
                catch
                    count = count;
                end
                j = j+1;
            end

        mean_irf_f = sum(m_irf_path_f, 2)/10; 
        irfs_full(:, n_p1) = mean_irf_f; 
    end
    
    dis_full = sampleirf_full((n_obs*hs+1):n_obs*(h+1)) - irfs_full((n_obs*hs+1):n_obs*(h+1), :); 
    dis_full_sqr = sum(dis_full.^2, 1);
    dis_full_sqr = squeeze(dis_full_sqr);
    
    p1_loc = find(dis_full_sqr == min(dis_full_sqr));
    est_p1 = p1_range(p1_loc);
    v_est_p1(i) = est_p1;
    v_obj_1 = zeros(length(p1_range), 1);
    v_obj_2 = zeros(length(p1_range), 1);
    v_obj_opt_1 = zeros(length(p1_range), 1);
    v_obj_opt_2 = zeros(length(p1_range), 1);
    
    pick_reg_a_1 = pick_c_1/(T^(1/3));
    pick_reg_a_2 = pick_c_2/(T^(1/3));

    for n_p1 = 1: length(p1_range)
        reg_dis_full = dis_full(:, n_p1);
        reg_sqr_full = (phi_f' * reg_dis_full).^2; % T by 1 vector
        obj_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * reg_sqr_full;
        obj_2 = (diag(lambda_f)./(diag(lambda_f).^2))' * reg_sqr_full;
        v_obj_1(n_p1) = obj_1;
        v_obj_2(n_p1) = obj_2; 
        
        reg_sqr_full_opt = (phi_f_opt' * reg_dis_full).^2; % T by 1 vector
        obj_opt_1 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * reg_sqr_full_opt;
        obj_opt_2 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2))' * reg_sqr_full_opt;
        v_obj_opt_1(n_p1) = obj_opt_1;
        v_obj_opt_2(n_p1) = obj_opt_2; 
    end
    
    p1_reg_loc = find(v_obj_1 == min(v_obj_1));
    p1_nonreg_loc = find(v_obj_2 == min(v_obj_2));
    p1_opt_reg_loc = find(v_obj_opt_1 == min(v_obj_opt_1));
    p1_opt_nonreg_loc = find(v_obj_opt_2 == min(v_obj_opt_2));
%     v_p1_reg_loc = [v_p1_reg_loc; p1_reg_loc];
%     v_p1_nonreg_loc = [v_p1_nonreg_loc; p1_nonreg_loc];
    est_p1_reg = p1_range(p1_reg_loc)
    est_p1_nonreg = p1_range(p1_nonreg_loc)
    est_p1_opt_reg = p1_range(p1_opt_reg_loc)
    est_p1_opt_nonreg = p1_range(p1_opt_nonreg_loc)
    
    v_est_p1_reg(i) = est_p1_reg;
    v_est_p1_nonreg(i) = est_p1_nonreg;
    v_est_p1_opt_reg(i) = est_p1_opt_reg;
    v_est_p1_opt_nonreg(i) = est_p1_opt_nonreg;
    valid = valid +1;
    
    catch
        disp('sample failed')
        valid = valid;
    end
    
end

mid = s/2;

std_p1_1 = std(v_est_p1(1:mid));
std_p1_2 = std(v_est_p1(mid+1:s));

std_p1_reg_1 = std(v_est_p1_reg(1:mid));
std_p1_reg_2 = std(v_est_p1_reg(mid+1:s));

std_p1_nonreg_1 = std(v_est_p1_nonreg(1:mid));
std_p1_nonreg_2 = std(v_est_p1_nonreg(mid+1:s));

std_p1_opt_reg_1 = std(v_est_p1_opt_reg(1:mid));
std_p1_opt_reg_2 = std(v_est_p1_opt_reg(mid+1:s));

std_p1_opt_nonreg_1 = std(v_est_p1_opt_nonreg(1:mid));
std_p1_opt_nonreg_2 = std(v_est_p1_opt_nonreg(mid+1:s));

ncover_noweight_5 = coverage(std_p1_2, 0.05, v_est_p1(1:mid), 0.469) ...
                    + coverage(std_p1_1, 0.05, v_est_p1(mid+1:s), 0.469)
                
ncover_noweight_10 = coverage(std_p1_2, 0.1, v_est_p1(1:mid), 0.469) ...
                    + coverage(std_p1_1, 0.1, v_est_p1(mid+1:s), 0.469)

ncover_reg_5 = coverage(std_p1_reg_2, 0.05, v_est_p1_reg(1:mid), 0.469) ...
                    + coverage(std_p1_reg_1, 0.05, v_est_p1_reg(mid+1:s), 0.469)
                
ncover_reg_10 = coverage(std_p1_reg_2, 0.1, v_est_p1_reg(1:mid), 0.469) ...
                    + coverage(std_p1_reg_1, 0.1, v_est_p1_reg(mid+1:s), 0.469)
                
ncover_nonreg_5 = coverage(std_p1_nonreg_2, 0.05, v_est_p1_nonreg(1:mid), 0.469) ...
                    + coverage(std_p1_nonreg_1, 0.05, v_est_p1_nonreg(mid+1:s), 0.469)
                
ncover_nonreg_10 = coverage(std_p1_nonreg_2, 0.1, v_est_p1_nonreg(1:mid), 0.469) ...
                    + coverage(std_p1_nonreg_1, 0.1, v_est_p1_nonreg(mid+1:s), 0.469)
                
ncover_opt_reg_5 = coverage(std_p1_opt_reg_2, 0.05, v_est_p1_opt_reg(1:mid), 0.469) ...
                    + coverage(std_p1_opt_reg_1, 0.05, v_est_p1_opt_reg(mid+1:s), 0.469)
                
ncover_opt_reg_10 = coverage(std_p1_opt_reg_2, 0.1, v_est_p1_opt_reg(1:mid), 0.469) ...
                    + coverage(std_p1_opt_reg_1, 0.1, v_est_p1_opt_reg(mid+1:s), 0.469)
                
ncover_opt_nonreg_5 = coverage(std_p1_opt_nonreg_2, 0.05, v_est_p1_opt_nonreg(1:mid), 0.469) ...
                    + coverage(std_p1_opt_nonreg_1, 0.05, v_est_p1_opt_nonreg(mid+1:s), 0.469)
                
ncover_opt_nonreg_10 = coverage(std_p1_opt_nonreg_2, 0.1, v_est_p1_opt_nonreg(1:mid), 0.469) ...
                    + coverage(std_p1_opt_nonreg_1, 0.1, v_est_p1_opt_nonreg(mid+1:s), 0.469)
save T236p4H2180_subset_opt_p1 v_est_p1 v_est_p1_reg v_est_p1_nonreg...
    v_est_p1_opt_reg v_est_p1_opt_nonreg...
    ncover_noweight_5 ncover_noweight_10 ncover_reg_5 ncover_reg_10...
    ncover_nonreg_5 ncover_nonreg_10 ncover_opt_reg_5 ncover_opt_reg_10...
    ncover_opt_nonreg_5 ncover_opt_nonreg_10
